from examples.ags.scripts.optimizer import Optimizer
from configs.models_config import ModelsConfig


# Crucial Parameters
dataset = "HumanEval"  # DatasetType
sample = 4  # Sample Count, which means how many workflows will be resampled from generated workflows
question_type = "code"  # Question Type
optimized_path = "examples/ags/scripts/optimized"  # Optimized Result Save Path

# Initialize LLM Model
four_o_llm_config = ModelsConfig.default().get("gpt-4o")
deepseek_llm_config = ModelsConfig.default().get("deepseek-chat")
mini_llm_config = ModelsConfig.default().get("gpt-4o-mini")
gpt_llm_config = ModelsConfig.default().get("gpt-35-turbo")
claude_llm_config = ModelsConfig.default().get("claude-3-5-sonnet-20240620")

# Initialize Operators List
operators = [
    "Custom",
    "CustomCodeGenerate",
    "ScEnsemble",
    "Test",
]

# Create an optimizer instance
optimizer = Optimizer(
    dataset=dataset,
    opt_llm_config=claude_llm_config,
    exec_llm_config=deepseek_llm_config,
    operators=operators,
    optimized_path=optimized_path,
    sample=sample,
    question_type=question_type,
)

# Run the optimizer
# optimizer.optimize("Graph", 20)
optimizer.optimize("Test")
# optimizer.optimize("Operator")

